<?
$PXWO_DEBUG = false;
//=================================
//		GATEWAY SCRIPT
//=================================
if (!function_exists(PXWO_remote_error)) {
	function PXWO_remote_error($str) {
		global $PXWO_DEBUG;
		
		echo $str;
		echo "<br><br>";
		if ($PXWO_DEBUG) highlight_string(print_r($PXWO_DEBUG(),1));
		die();
	}
}
if (!function_exists(PXWO_error)) {
	function PXWO_error($str) {
		global $PXWO_DEBUG;
		echo $str;
		echo "<br><br>";
		if ($PXWO_DEBUG) highlight_string(print_r($PXWO_DEBUG(),1));
		die();
	}
}
function PXWO_log($str = false, $read = 0) {
   static $log;
   if ($str!==false) $log .=$str."\n";
   if (!$read) return false;
   else return $log;
}
function PXWO_debug() {
	PXWO_log("*******************");
	PXWO_log("	DEBUG	");
	return PXWO_log("*******************",1);
}
function PXWO_getmicrotime() {
   list($usec, $sec) = explode(" ",microtime()); 
   return ((float)$usec + (float)$sec); 
} 
function PXWO_gateway($DATA) {
	static $n_conn = 0;
	$start_request = PXWO_getmicrotime();
	if (!$n_conn) {
		PXWO_log("*******************");
		PXWO_log("	AVVIO GATEWAY	");
	}
	PXWO_log("*******************");
	$n_conn++;
	PXWO_log("CLIENT: connessione ".$n_conn);
	PXWO_log("CLIENT: azione ".$DATA["action"]);
	PXWO_log("CLIENT: inizializzo dati");
	$DATASET = urlencode(serialize($DATA));
	$url = "http://gateway.fattura-facile.it/exec.php?DATASET=".$DATASET;
	PXWO_log("CLIENT: connessione...");
	$start_server = PXWO_getmicrotime();
	if (!($CON = @file($url))) PXWO_error("impossibile connettersi al server remoto");
	$time_server = PXWO_getmicrotime() - $start_server;
	PXWO_log("CLIENT: connesso");
	PXWO_log("CLIENT: query server eseguita in ".$time_server. " secondi");
	PXWO_log("CLIENT: estrazione dati");
	$FILE = implode("",$CON);
	PXWO_log("CLIENT: download ".strlen($FILE)." byte");
	$CONNECT = urldecode($FILE);
	PXWO_log("CLIENT: dati estratti");
	if (empty($CONNECT)) PXWO_error("nessuna risposta dal server");
	PXWO_log("CLIENT: inizio parsing dati");
	$DATASET = unserialize($CONNECT);
	PXWO_log("CLIENT: parsing dati completato");
	if (empty($DATASET)) PXWO_error("il server non ha risposto correttamente: ".$CONNECT);
	PXWO_log("SERVER: ".$DATASET["txt"]);
	if (!$DATASET["status"]) PXWO_remote_error($DATASET["error"]);
	PXWO_log("CLIENT: richiesta eseguita in ".(PXWO_getmicrotime() - $start_request)." secondi");
	return $DATASET;
}
// LOGIN
function login($username, $password) {
	$D["action"] = "login";
	$D["user"] = $username;
	$D["pass"] = $password;
	$R = PXWO_gateway($D);
	return $R["session"];
}
// CLIENTI
function listCustomer($session) {
	$D["action"] = "listCustomer";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function getCustomer($session, $id) {
	$D["action"] = "getCustomer";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function newCustomer($session, $M) {
	$D["action"] = "newCustomer";
	$D["session"] = $session;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
	return $R["newid"];
}
function modCustomer($session, $id, $M) {
	$D["action"] = "modCustomer";
	$D["session"] = $session;
	$D["id"] = $id;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
}
function delCustomer($session, $id) {
	$D["action"] = "delCustomer";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
}
function listHSI($session) {
	$D["action"] = "listHSI";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function listHDYMU($session) {
	$D["action"] = "listHDYMU";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
// PRODOTTI
function listUnit($session) {
	$D["action"] = "listUnit";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function listProduct($session) {
	$D["action"] = "listProduct";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function getProduct($session, $id) {
	$D["action"] = "getProduct";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function newProduct($session, $M) {
	$D["action"] = "newProduct";
	$D["session"] = $session;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
	return $R["newid"];
}
function modProduct($session, $id, $M) {
	$D["action"] = "modProduct";
	$D["session"] = $session;
	$D["id"] = $id;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
}
function delProduct($session, $id) {
	$D["action"] = "delProduct";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
}
// ORDINI
function listOrder($session) {
	$D["action"] = "listOrder";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function listCustomerOrder($session, $id, $use_referrer = 0) {
	$D["action"] = "listCustomerOrder";
	$D["session"] = $session;
	$D["id"] = $id;
	$D["use_referrer"] = $use_referrer;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function listStatusOrder($session) {
	$D["action"] = "listStatusOrder";
	$D["session"] = $session;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function getOrder($session, $id) {
	$D["action"] = "getOrder";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function newOrder($session, $M) {
	$D["action"] = "newOrder";
	$D["session"] = $session;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
	return $R["newid"];
}
function modOrder($session, $id, $M) {
	$D["action"] = "modOrder";
	$D["session"] = $session;
	$D["id"] = $id;
	$D["data"] = $M;
	$R = PXWO_gateway($D);
}
function delOrder($session, $id) {
	$D["action"] = "delOrder";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
}
//FATTURE
function listCustomerInvoice($session, $id, $use_referrer = 0) {
	$D["action"] = "listCustomerInvoice";
	$D["session"] = $session;
	$D["id"] = $id;
	$D["use_referrer"] = $use_referrer;
	$R = PXWO_gateway($D);
	return $R["data"];
}
function getPdfInvoice($session, $id, $download) {
	$D["action"] = "getPdfInvoice";
	$D["session"] = $session;
	$D["id"] = $id;
	$R = PXWO_gateway($D);
	Header('Content-Type: application/pdf');
	if(headers_sent()) PXWO_error("gli header sono gi stati inviati, impossibile inviare file pdf");
	if (!$download) {
		Header('Content-Length: '.strlen($R["data"]["source"]));
		Header('Content-disposition: inline; filename='.$R["data"]["filename"]);
	} else {
	//Download file
		if(isset($HTTP_SERVER_VARS['HTTP_USER_AGENT']) and strpos($HTTP_SERVER_VARS['HTTP_USER_AGENT'],'MSIE'))
			Header('Content-Type: application/force-download');
		else
			Header('Content-Type: application/octet-stream');

		Header('Content-Length: '.strlen($R["data"]["source"]));
		Header('Content-disposition: attachment; filename='.$R["data"]["filename"]);
	}
	echo $R["data"]["source"];
	exit();
}
?>
